<?php

defined('ABSPATH') || exit;

use \UtillzCore\Inc\Src\Request\Request;
use \UtillzCore\Inc\Src\Listing\Listing;
use \UtillzCore\Inc\Src\Form\Component as Form;
use \UtillzCore\Inc\Src\User;

$request = Request::instance();
$user = User::instance();
$form = new Form( Form::Storage_Request );
$listing = new Listing( $request->get('listing_id') );

?>

<?php if( ! is_user_logged_in() ): ?>

	<div class="ulz-modal-container ulz-scrollbar">
		<div class="ulz--icon">
			<i class="material-icons">highlight_off</i>
			<p><?php esc_html_e( 'You need to login in order to send applications', 'utillz-core' ); ?></p>
		</div>
	</div>

<?php else: ?>

	<div class="ulz-modal-container ulz-scrollbar">
		<?php if( $user->id == $listing->post->post_author ): ?>

			<div class="ulz--icon">
			    <i class="material-icons">highlight_off</i>
			    <p><?php esc_html_e( 'You can\'t send application to yourself', 'utillz-core' ); ?></p>
			</div>

		<?php else: ?>

			<?php $action = $listing->type->get_action_type('application'); ?>

			<div class="ulz--icon ulz-none">
			    <i class="fas fa-check"></i>
			    <p><?php esc_html_e( 'You application was sent successfully', 'utillz-core' ); ?></p>
			</div>

			<form class="ulz-form">

				<?php if( $action->fields->form ): ?>
					<div class="ulz-grid">
						<?php

				            foreach( $action->fields->form as $item ) {

				                if( $item->fields->show_if_guest && is_user_logged_in() ) {
				                    continue;
				                }

				                $field = $form->create( Ucore()->prefix_item( $item ) );

				                if( ! Ucore()->is_error( $field ) ) {
				                    echo $field->get();
				                }else{
				                    echo $field->get_error();
				                }

				            }

				        ?>
					</div>
				<?php else: ?>
					<p class="ulz-weight-600 ulz-text-center ulz-mb-0"><?php esc_html_e( 'Application form is empty.', 'utillz-core' ); ?></p>
				<?php endif; ?>

			</form>

		</div>

		<?php if( $action->fields->form ): ?>
			<div class="ulz-modal-footer ulz--top-border ulz-text-center">
				<a href="#" class="ulz-button ulz-button-accent ulz-modal-button" data-action="send-application">
					<span><?php esc_html_e( 'Submit Application', 'utillz-core' ); ?></span>
					<?php Ucore()->preloader(); ?>
				</a>
			</div>
		<?php endif; ?>

	<?php endif; ?>
<?php endif; ?>

<?php

/*
 * preloader
 *
 */
Ucore()->the_template('globals/preloader');

?>
